<?php

defined( 'ABSPATH' ) or die( 'This page may not be accessed directly.' );

class Metrix_Admin {
	public static string $FORM_NONCE_ACTION = 'form_nonce_action';
	public static string $FORM_NONCE_FIELD = 'form_nonce_field';
	public static string $ICON_BASE64 = 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjUiIGhlaWdodD0iMjUiIHZpZXdCb3g9IjAgMCAyNSAyNSIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KICA8cmVjdCB5PSIxNC4yNzM0IiB3aWR0aD0iNi41NjU3NyIgaGVpZ2h0PSIxMC40MjY4IiBmaWxsPSIjNTE0M0Q2Ii8+CiAgPHBhdGggZD0iTTE1LjYzMDIgNi44NDM3NUg5LjA2NDQ1VjExLjU4MzJMMTIuMzQ3MyAxNS4zNzQ4TDE1LjYzMDIgMTEuNTgzMlY2Ljg0Mzc1WiIgZmlsbD0iIzUxNDNENiIvPgogIDxwYXRoIGQ9Ik04Ljk0MzAxIDI0LjcwMzFMMTUuNTA4OCAyNC43MDMxTDE1LjUwODggMTUuMjI0MkwxMi4yMjU5IDE4LjU0MThMOC45NDMwMSAxNS4yMjQyTDguOTQzMDEgMjQuNzAzMVoiIGZpbGw9IiM1MTQzRDYiLz4KICA8cmVjdCB4PSIxNy44ODU3IiB5PSIwLjA1NDY4NzUiIHdpZHRoPSI2LjU2NTc3IiBoZWlnaHQ9IjI0LjY0NTIiIGZpbGw9IiM1MTQzRDYiLz4KPC9zdmc+Cg==';

	public static function init(): void {
		add_action( 'admin_menu', array( __CLASS__, 'add_admin_page' ) );
	}

	public static function add_admin_page(): void {
		$metrix_menu = add_menu_page(
			'Metrix Plugin',
			'Metrix',
			'manage_options',
			'metrix',
			array( __CLASS__, 'admin_menu' ),
			Metrix_Admin::$ICON_BASE64,
		);

		Metrix_Admin::save_form_value();
		add_action( 'load-' . $metrix_menu, array( __CLASS__, 'admin_custom_load' ) );
	}


	public static function admin_menu(): void {
		require_once plugin_dir_path( __FILE__ ) . '/views/config.php';
	}


	public static function admin_custom_scripts(): void {
		wp_enqueue_style( 'bootstrap', plugin_dir_url( __FILE__ ) . 'views/css/bootstrap.css' );
		wp_enqueue_script( 'site', plugin_dir_url( __FILE__ ) . 'js/admin.js' );
	}

	public static function save_form_value(): void {
		if ( isset( $_POST['app_id'] ) ) {
			if (
				isset( $_POST[ Metrix_Admin::$FORM_NONCE_FIELD ] ) &&
				wp_verify_nonce( $_POST[ Metrix_Admin::$FORM_NONCE_FIELD ], Metrix_Admin::$FORM_NONCE_ACTION )
			) {
				Metrix_Admin::save_config( $_POST );
				Metrix_Admin::reload_page();
			} else {
				// Nonce verification failed
				wp_die( 'Security check failed' );
			}
		}
	}

	private static function reload_page(): void {
		?>
        <script type='text/javascript'>
            window.location = document.location.href;
        </script>;
		<?php
	}

	public static function save_config( $form ): void {
		if ( $form ) {
			$new_settings = array(
				'app_id'              => $form['app_id'],
				'api_key'             => $form['api_key'],
				'push_public_key'     => $form['push_public_key'],
				'push_backdrop_text'  => $form['push_backdrop_text'],
				'push_backdrop_delay' => $form['push_backdrop_delay'],
			);

            self::applyCheckboxValue( $form , $new_settings, 'push_enabled');
            self::applyCheckboxValue( $form , $new_settings, 'push_show_bell');
            self::applyCheckboxValue( $form , $new_settings, 'push_show_backdrop');

			Metrix_Settings::save_settings( $new_settings );
		}
	}

	private static function applyCheckboxValue( $form, &$new_settings, $key ): void {
		if ( array_key_exists( $key, $form ) ) {
			$new_settings[ $key ] = $form[ $key ] === 'on';
		} else {
			$new_settings[ $key ] = false;
		}
	}

	public static function admin_custom_load(): void {
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_custom_scripts' ) );

		$settings = Metrix_Settings::get_settings();
		if (
			$settings['app_id'] === '' ||
			$settings['api_key'] === ''
		) {
			function admin_notice_setup_not_complete() {
				?>
                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        activateSetupTab('setup/0');
                    });
                </script>
                <div class="error notice onesignal-error-notice">
                    <p>
                        <strong>Metrix Plugin:</strong>
                        <em>Your setup is not complete. Please follow the Setup guide to set up web push
                            notifications. Both the App ID and API Key fields are required.
                        </em>
                    </p>
                </div>
				<?php
			}

			add_action( 'admin_notices', 'admin_notice_setup_not_complete' );
		}
	}
}
