<?php

defined( 'ABSPATH' ) or die( 'This page may not be accessed directly.' );

class Metrix_Public {
	public static function init(): void {
		add_action( 'wp_head', [ 'Metrix_SDK', 'add_sdk_script' ] );
		add_action( 'wp_footer', [ 'Metrix_SDK', 'configure_sdk' ] );
		add_action( 'wp_footer', [ 'Metrix_Public', 'send_user_data' ] );
		add_action( 'wp_logout', [ 'Metrix_SDK', 'deauthorize_user' ] );

		$settings = Metrix_Settings::get_settings();

		if ( $settings['push_enabled'] ) {
			add_action( 'wp_head', [ 'Metrix_Service_Worker', 'add_service_worker_js_file_to_root' ] );
		}
	}

	public static function send_user_data(): void {
		$current_user = wp_get_current_user();

		if ( $current_user->ID !== 0 ) {
			Metrix_SDK::authorize_user( $current_user->ID );
			Metrix_SDK::set_email( $current_user->user_email );
			Metrix_SDK::set_first_name( $current_user->user_firstname ? $current_user->user_firstname : $current_user->user_login );
			Metrix_SDK::set_last_name( $current_user->user_lastname );
			Metrix_SDK::set_custom_attribute( 'registered_at', strtotime( $current_user->user_registered ) );
			Metrix_SDK::set_custom_attribute( 'display_name', $current_user->display_name );
			Metrix_SDK::set_custom_attribute( 'user_nickname', $current_user->nickname );
			Metrix_SDK::set_custom_attribute( 'roles', implode( ",", $current_user->roles ) );
		}
	}
}