<?php

defined( 'ABSPATH' ) or die( 'This page may not be accessed directly.' );

class Metrix_SDK {
	public static function init(): void {
		Metrix_SDK::add_sdk_script();
		Metrix_SDK::configure_sdk();
	}

	public static function add_sdk_script(): void {
		?>
        <script src="https://cdn.metrix.ir/sdk/web/metrix.umd-<?php echo constant( 'METRIX_SDK_VERSION' ) ?>.js"></script>
		<?php
	}

	public static function configure_sdk(): void {
		$wp_settings = Metrix_Settings::get_settings();
		?>
        <script>
            Metrix.init("<?php echo $wp_settings['app_id'] ?>", "<?php echo $wp_settings['api_key'] ?>", {
                push: {
                    enabled: <?php echo $wp_settings['push_enabled'] ? "true" : "false" ?>,
                    publicKey: "<?php echo $wp_settings['push_public_key'] ?>",
                    showBell: <?php echo $wp_settings['push_show_bell'] ? "true" : "false" ?>,
                    showBackdrop: <?php echo $wp_settings['push_show_backdrop'] ? "true" : "false" ?>,
                    backdropText: "<?php echo $wp_settings['push_backdrop_text'] ?>",
                    backdropDelay: <?php echo $wp_settings['push_backdrop_delay'] ?>,
                },
            });
        </script>
		<?php
	}

	public static function authorize_user( $user_id ): void {
		?>
        <script>
            Metrix.authorizeUser("<?php echo $user_id ?>");
        </script>
		<?php
	}

	public static function deauthorize_user( $user_id ): void {
		?>
        <script>
            Metrix.deauthorizeUser();
        </script>
		<?php
	}

	public static function set_first_name( $first_name ): void {
		?>
        <script>
            Metrix.setFirstName("<?php echo $first_name ?>");
        </script>
		<?php
	}

	public static function set_last_name( $last_name ): void {
		?>
        <script>
            Metrix.setLastName("<?php echo $last_name ?>");
        </script>
		<?php
	}

	public static function set_email( $email ): void {
		?>
        <script>
            Metrix.setEmail("<?php echo $email ?>");
        </script>
		<?php
	}

	public static function set_hashed_email( $hashedEmail ): void {
		?>
        <script>
            Metrix.setHashedEmail("<?php echo $hashedEmail ?>");
        </script>
		<?php
	}

	public static function set_phone_number( $phone_number ): void {
		?>
        <script>
            Metrix.setHashedEmail("<?php echo $phone_number ?>");
        </script>
		<?php
	}

	public static function set_hashed_phone_number( $hashed_phone_number ): void {
		?>
        <script>
            Metrix.setHashedEmail("<?php echo $hashed_phone_number ?>");
        </script>
		<?php
	}

	public static function set_country( $country ): void {
		?>
        <script>
            Metrix.setCountry("<?php echo $country ?>");
        </script>
		<?php
	}

	public static function set_city( $city ): void {
		?>
        <script>
            Metrix.setCity("<?php echo $city ?>");
        </script>
		<?php
	}

	public static function set_region( $region ): void {
		?>
        <script>
            Metrix.setRegion("<?php echo $region ?>");
        </script>
		<?php
	}

	public static function set_locality( $locality ): void {
		?>
        <script>
            Metrix.setLocality("<?php echo $locality ?>");
        </script>
		<?php
	}

	public static function set_gender( $gender ): void {
		?>
        <script>
            Metrix.setGender("<?php echo $gender ?>");
        </script>
		<?php
	}

	public static function set_birthday( $birthday ): void {
		?>
        <script>
            Metrix.setBirthday(<?php echo $birthday ?>);
        </script>
		<?php
	}

	public static function set_custom_attribute( $key, $value ): void {
		?>
        <script>
            Metrix.setCustomAttribute("<?php echo $key ?>", "<?php echo $value ?>");
        </script>
		<?php
	}

	public static function set_custom_user_id( $id ): void {
		?>
        <script>
            Metrix.setCustomUserId("<?php echo $id ?>");
        </script>
		<?php
	}

	public static function new_event( $slug, $custom_attributes ): void {
		?>
        <script>
            Metrix.newEvent("<?php echo $slug ?>", <?php echo json_encode( $custom_attributes, JSON_PRETTY_PRINT ) ?>);
        </script>
		<?php
	}

	public static function new_event_by_name( $name, $custom_attributes ): void {
		?>
        <script>
            Metrix.newEventByName("<?php echo $name ?>", <?php echo json_encode( $custom_attributes, JSON_PRETTY_PRINT ) ?>);
        </script>
		<?php
	}
}
