<?php

defined( 'ABSPATH' ) or die( 'This page may not be accessed directly.' );

class Metrix_Settings {
	public static function get_settings() {
		$defaults = array(
			'app_id'          => '',
			'api_key'         => '',
			'push_enabled'    => false,
			'push_public_key' => '',
			'push_show_bell'  => true,
			'push_show_backdrop' => false,
			'push_backdrop_text' => '',
			'push_backdrop_delay' => 0,
		);

		$metrix_settings = get_option( 'wp_metrix_settings' );

		if ( empty( $metrix_settings ) ) {
			update_option( "wp_metrix_settings", $defaults );
			$metrix_settings = $defaults;
		} else {
			$metrix_settings = array_merge( $defaults, $metrix_settings );
			update_option( "wp_metrix_settings", $metrix_settings );
		}

		return $metrix_settings;
	}

	public static function save_settings( $settings ): void {
		update_option( "wp_metrix_settings", $settings );
	}
}
