<?php

defined( 'ABSPATH' ) or die( 'This page may not be accessed directly.' );
$settings = Metrix_Settings::get_settings();

?>

<form action="" method="POST">
	<?php wp_nonce_field( Metrix_Admin::$FORM_NONCE_ACTION, Metrix_Admin::$FORM_NONCE_FIELD ); ?>
    <div class="wp-core-ui wrap" style="direction: ltr">
        <h1>Metrix Plugin Configuration</h1>
        <div class="card pt-4">
            <h6>Main Settings</h6>
            <p class="text-secondary">Please fill in the required fields below.</p>
            <table class="form-table">
                <tr>
                    <th>
                        <label class="form-label">App ID*</label>
                    </th>
                    <td>
                        <input
                                type="text"
                                class="regular-text"
                                name="app_id"
                                value="<?php echo $settings['app_id']; ?>"
                        >
                    </td>
                </tr>
                <tr>
                    <th>
                        <label class="form-label">Api Key*</label>
                    </th>
                    <td>
                        <input
                                type="text"
                                class="regular-text"
                                name="api_key"
                                value="<?php echo $settings['api_key']; ?>"
                        >
                    </td>
                </tr>
            </table>
        </div>

        <div class="card pt-4">
            <div class="d-flex justify-content-between align-items-center">
                <h6>Push Notification</h6>
                <label for="push_enabled">
                    <input
                            type="checkbox"
                            name="push_enabled"
                            id="push_enabled"
						<?php if ( $settings['push_enabled'] ) {
							echo "checked";
						} ?>
                    >
                    Enable push notification
                </label>
            </div>
            <p class="text-secondary">
                Enabling push notifications will enhance user experience by delivering
                timely and relevant content directly to your users.
            </p>
            <div
                    id="push_config"
				<?php if ( ! $settings['push_enabled'] ) {
					echo "style=\"display: none\"";
				} ?>
            >
                <table class="form-table">
                    <tr>
                        <th>
                            <label class="form-label">Public Key*</label>
                        </th>
                        <td>
                            <input
                                    type="text"
                                    class="regular-text"
                                    name="push_public_key"
                                    value="<?php echo $settings['push_public_key']; ?>"
                            >
                        </td>
                    </tr>
                </table>
                <div class="d-flex flex-column">
                    <label for="show_bell">
                        <input
                                type="checkbox"
                                name="push_show_bell"
                                id="push_show_bell"
							<?php if ( $settings['push_show_bell'] ) {
								echo "checked";
							} ?>
                        >
                        Show bell
                    </label>
                    <label for="show_backdrop">
                        <input
                                type="checkbox"
                                name="push_show_backdrop"
                                id="push_show_backdrop"
							<?php if ( $settings['push_show_backdrop'] ) {
								echo "checked";
							} ?>
                        >
                        Show backdrop
                    </label>
                    <table
                            id="backdrop_config"
                            class="form-table"
						<?php if ( ! $settings['push_show_backdrop'] ) {
							echo "style=\"display: none\"";
						} ?>
                    >
                        <tr>
                            <th>
                                <label class="form-label">Backdrop Text*</label>
                            </th>
                            <td>
                                <input
                                        type="text"
                                        class="regular-text"
                                        name="push_backdrop_text"
                                        value="<?php echo $settings['push_backdrop_text']; ?>"
                                >
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <label
                                        class="form-label"
                                >
                                    Backdrop Delay (in Millisecond)*
                                </label>
                            </th>
                            <td>
                                <input
                                        type="number"
                                        class="regular-text"
                                        name="push_backdrop_delay"
                                        value="<?php echo $settings['push_backdrop_delay']; ?>"
                                >
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <p class="submit">
        <button type="submit" class="button button-primary">Save</button>
    </p>
</form>