<?php

defined( 'ABSPATH' ) or die( 'This page may not be accessed directly.' );
$settings = Metrix_Settings::get_settings();

?>

<div class="card pt-4">
    <div class="d-flex justify-content-between">
        <h6>Triggers</h6>
    </div>
    <p class="text-secondary">
        You can define triggers here
    </p>
    <table class="form-table" id="triggers-container">
		<?php foreach ( $settings['triggers'] as $trigger ): ?>
            <tr>
                <th>
                    <label>
                        <input type="text" class="regular-text" name="api_key"
                               value="<?php echo $settings['api_key']; ?>">
                    </label>
                </th>
                <td>
                    <label for="push_enabled">
                        <input type="text" class="regular-text" name="api_key"
                               value="<?php echo $settings['api_key']; ?>">
                    </label>
                    <button type="button" onclick="removeInput(this)">-</button>
                </td>
            </tr>
		<?php endforeach; ?>
    </table>

    <script>
        function addInput() {
            const container = document.getElementById('triggers-container');
            const inputGroup = document.createElement('div');
            inputGroup.className = 'input-group';
            inputGroup.innerHTML = `
                <tr>
                    <th>
                        <label>
                            <input type="text" class="regular-text" name="api_key" >
                        </label>
                    </th>
                    <td>
                        <label>
                            <input type="text" class="regular-text" name="api_key" >
                        </label>
                        <button type="button" onclick="removeInput(this)">-</button>
                    </td>
                </tr>
            `;
            container.appendChild(inputGroup);
        }

        function removeInput(button) {
            const inputGroup = button.parentNode;
            inputGroup.remove();
        }
    </script>
</div>